<?php
/**
 * Class: Counter
 * Name: Counter
 * Slug: stratum-counter
 */

namespace Stratum_Menu;

use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Mega_Menu extends Stratum_Menu_Widget_Base {
	protected $widget_name = 'mega-menu';

    public function __construct($data = [], $args = null) {
        parent::__construct( $data, $args );
    }

	public function get_title() {
		return esc_html__( 'Mega Menu', 'stratum-menu' );
	}

	public function get_script_depends() {
        return [
			'font-awesome-4-shim'
		];
	}

	public function get_style_depends() {
        return [
			'font-awesome-5-all',
			'font-awesome-4-shim'
        ];
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_categories() {
		return [ 'stratum-widgets' ];
    }

	public function get_keywords() {
		return [ 'menu', 'nav', 'button', 'megamenu' ];
	}

    protected function register_controls() {
        $controls  = $this;
        $unique_id = $controls->get_id();

		/*-----------------------------------------------------------------------------------*/
        /*	Content Tab
        /*-----------------------------------------------------------------------------------*/

        $controls->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Menu', 'stratum-menu' )
			]
        );

			$controls->add_control(
				'menu',
				[
					'label'   => esc_html__( 'Select Menu', 'stratum-menu' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => stratum_menu_get_menu_list(),
					'description' => sprintf( __( 'Manage <a href="%s" target="_blank">Menus</a>.', 'stratum-menu' ), admin_url( 'nav-menus.php' ) ),
				]
			);

			$controls->add_control(
				'layout',
				[
					'label'   => esc_html__( 'Layout', 'stratum-menu' ),
					'type'    => Controls_Manager::SELECT,
					'prefix_class' => 'stratum-mega-menu-layout-',
					'default' => 'horizontal',
					'options' => [
						'horizontal' => esc_html__( 'Horizontal', 'stratum-menu' ),
						'vertical'  => esc_html__( 'Vertical', 'stratum-menu' ),
					],
				]
			);

			$controls->add_control(
				'menu_animation',
				[
					'label'   	   => esc_html__( 'Animation', 'stratum-menu' ),
					'prefix_class' => 'stratum-menu-animation-',
					'type'    	   => Controls_Manager::SELECT,
					'options' 	   => [
						'none'   	 => esc_html__( 'None', 'stratum-menu' ),
						'fade'   	 => esc_html__( 'Fade', 'stratum-menu' ),
						'move-up'    => esc_html__( 'Move Up', 'stratum-menu' ),
						'move-right' => esc_html__( 'Move Right', 'stratum-menu' ),
						'move-down'  => esc_html__( 'Move Down', 'stratum-menu' ),
						'move-left'  => esc_html__( 'Move Left', 'stratum-menu' ),
					],
					'default'      => 'move-up',
				]
			);

		$controls->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*	Style Tab
		/*-----------------------------------------------------------------------------------*/

		$controls->start_controls_section(
			'section_container',
			[
				'label' => esc_html__( 'Menu', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'menu_container_min_width',
				[
					'label'       => esc_html__( 'Width', 'stratum-menu' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units' => [ '%', 'px' ],
					'range'       => [
						'px' => [
							'min' => 0,
							'max' => 2800,
						],
					],
					'selectors'   => [
						'{{WRAPPER}} .stratum-mega-menu > .stratum-menu-container > .stratum-menu-wrapper' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'menu_container_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-mega-menu > .stratum-menu-container > .stratum-menu-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'menu_container_border',
					'selector' => '{{WRAPPER}} .stratum-mega-menu > .stratum-menu-container > .stratum-menu-wrapper',
				]
			);

			$controls->add_responsive_control(
				'menu_container_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-mega-menu > .stratum-menu-container > .stratum-menu-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'menu_container_bg_color',
					'selector' => '{{WRAPPER}} .stratum-mega-menu > .stratum-menu-container > .stratum-menu-wrapper',
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'menu_container_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-mega-menu > .stratum-menu-container > .stratum-menu-wrapper',
				]
			);

			$controls->add_responsive_control(
				'menu_container_horizontal_alignment',
				[
					'label'   => esc_html__( 'Alignment', 'stratum-menu' ),
					'type'    => Controls_Manager::CHOOSE,
					'default'   => '',
					'prefix_class' => 'stratum-menu-aligment-',
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-left' : 'fa fa-align-right',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'stratum-menu' ),
							'icon'  => 'fa fa-align-center',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-right' : 'fa fa-align-left',
						]
					],
					'selectors' => [
						'{{WRAPPER}}.stratum-mega-menu-layout-horizontal .stratum-top-mega-menu' => 'justify-content: {{VALUE}};',
					],
					'condition' => [
						'layout' => 'horizontal'
					],
				]
			);

			$controls->add_responsive_control(
				'menu_container_vertical_alignment',
				[
					'label'   => esc_html__( 'Alignment', 'stratum-menu' ),
					'type'    => Controls_Manager::CHOOSE,
					'default'   => '',
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-left' : 'fa fa-align-right',
						],
						'stretch' => [
							'title' => esc_html__( 'Stretch', 'stratum-menu' ),
							'icon'  => 'fa fa-align-justify',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-right' : 'fa fa-align-left',
						],
					],
					'selectors' => [
						'{{WRAPPER}}.stratum-mega-menu-layout-vertical .stratum-top-mega-menu' => 'align-items: {{VALUE}};',
					],
					'condition' => [
						'layout' => 'vertical'
					],
				]
			);

		$controls->end_controls_section();

		$controls->start_controls_section(
			'section_menu_items',
			[
				'label'      => esc_html__( 'Item Style (First Level)', 'stratum-menu' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			]
		);

			$controls->add_responsive_control(
				'menu_items_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'menu_items_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; height: calc(100% - {{BOTTOM}}{{UNIT}} - {{TOP}}{{UNIT}});',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'menu_items_items_border',
					'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
				]
			);

			$controls->add_responsive_control(
				'menu_items_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'menu_items_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
				]
			);

			$controls->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'label'    => esc_html__( 'Typography', 'stratum-menu' ),
					'name'     => 'menu_items_typography',
					'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-item__link',
				]
			);

			$controls->add_control(
				'menu_top_items_text_align',
				[
					'label'     => esc_html__( 'Alignment', 'stratum-menu' ),
					'type'      => Controls_Manager::CHOOSE,
					'default'   => '',
					'options'   => [
						'left' => [
							'title' => esc_html__( 'Left', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-left' : 'fa fa-align-right',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'stratum-menu' ),
							'icon'  => 'fa fa-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-right' : 'fa fa-align-left',
						],
					],
					'prefix_class' => 'stratum-menu-items-ta-',
					'condition' => [
						'layout' => 'vertical',
						'menu_container_vertical_alignment' => ['', 'stretch'],
					]
				]
			);

			$controls->start_controls_tabs( 'menu_items_styles' );

				$controls->start_controls_tab(
					'menu_items_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'menu_items_text_color',
						[
							'label' => esc_html__( 'Text Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-item__link' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'menu_items_bg_color',
							'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'menu_items_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'menu_items_hover_text_color',
						[
							'label' => esc_html__( 'Text Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-item__link' => 'color: {{VALUE}}',

							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'menu_items_hover_bg_color',
							'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper',
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

			$controls->add_control(
				'menu_top_last_item_options',
				[
					'label' 	 => esc_html__( 'First and Last Items Options', 'stratum-menu' ),
					'type' 		 => Controls_Manager::HEADING,
					'separator'  => 'before'
				]
			);

			$controls->add_control(
				'menu_top_first_item_switcher',
				[
					'label' => esc_html__( 'First Item Options', 'stratum-menu' ),
					'type'  => Controls_Manager::SWITCHER,
				]
			);

			$controls->add_responsive_control(
				'menu_top_first_item_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:first-child > .stratum-menu-item__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'menu_top_first_item_switcher' => 'yes'
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'menu_top_first_item_border',
					'selector'  => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:first-child > .stratum-menu-item__wrapper',
					'condition' => [
						'menu_top_first_item_switcher' => 'yes'
					],
				]
			);

			$controls->add_responsive_control(
				'menu_top_first_item_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:first-child > .stratum-menu-item__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'menu_top_first_item_switcher' => 'yes'
					],
					'separator'  => 'after'
				]
			);

			$controls->add_control(
				'menu_top_last_item_switcher',
				[
					'label' => esc_html__( 'Last Item Options', 'stratum-menu' ),
					'type'  => Controls_Manager::SWITCHER,
				]
			);

			$controls->add_responsive_control(
				'menu_top_last_item_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:last-child > .stratum-menu-item__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'menu_top_last_item_switcher' => 'yes'
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'      => 'menu_top_last_item_border',
					'selector'  => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:last-child > .stratum-menu-item__wrapper',
					'condition' => [
						'menu_top_last_item_switcher' => 'yes'
					],
				]
			);

			$controls->add_responsive_control(
				'menu_top_last_item_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:last-child > .stratum-menu-item__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'menu_top_last_item_switcher' => 'yes'
					],
				]
			);

		$controls->end_controls_section();

        $controls->start_controls_section(
			'section_menu_items_submenu',
			[
				'label'      => esc_html__( 'Item Style (Nested Levels)', 'stratum-menu' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			]
		);

			$controls->add_responsive_control(
				'menu_items_submenu_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'menu_items_submenu_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_control(
				'sub_menu_text_alignment',
				[
					'label'   => esc_html__( 'Alignment', 'stratum-menu' ),
					'type'    => Controls_Manager::CHOOSE,
					'default' => '',
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-left' : 'fa fa-align-right',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'stratum-menu' ),
							'icon'  => 'fa fa-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-right' : 'fa fa-align-left',
						],
					],
					'separator' => 'before',
					'prefix_class' => 'stratum-submenu-items-ta-',
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'menu_items_submenu_items_border',
					'selector' => '{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
				]
			);

			$controls->add_responsive_control(
				'menu_items_submenu_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'menu_items_submenu_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
				]
			);

			$controls->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'label'    => esc_html__( 'Typography', 'stratum-menu' ),
					'name'     => 'menu_items_submenu_typography',
					'selector' => '{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-item__link',
				]
			);

			$controls->start_controls_tabs( 'menu_items_submenu_styles' );

				$controls->start_controls_tab(
					'menu_items_submenu_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'menu_items_submenu_text_color',
						[
							'label' => esc_html__( 'Text Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-item__link' => 'color: {{VALUE}}',

							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'menu_items_submenu_bg_color',
							'selector' => '{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'menu_items_submenu_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'menu_items_submenu_hover_text_color',
						[
							'label' => esc_html__( 'Text Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-mega-menu-sub-menu  > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-item__link' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'menu_items_submenu_hover_bg_color',
							'selector' => '{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper',
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

		$controls->add_control(
			'submenu_first_last_item_options',
			[
				'label' 	 => esc_html__( 'First and Last Items Options', 'stratum-menu' ),
				'type' 		 => Controls_Manager::HEADING,
				'separator'  => 'before'
			]
		);

		$controls->add_control(
			'submenu_first_item_switcher',
			[
				'label' => esc_html__( 'First Item Options', 'stratum-menu' ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$controls->add_responsive_control(
			'submenu_first_item_margin',
			[
				'label'      => esc_html__( 'Margin', 'stratum-menu' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item:first-child > .stratum-menu-item__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'submenu_first_item_switcher' => 'yes'
				],
			]
		);

		$controls->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'submenu_first_item_border',
				'selector'  => '{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item:first-child > .stratum-menu-item__wrapper',
				'condition' => [
					'submenu_first_item_switcher' => 'yes'
				],
			]
		);

		$controls->add_responsive_control(
			'submenu_first_item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item:first-child > .stratum-menu-item__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'submenu_first_item_switcher' => 'yes'
				],
				'separator'  => 'after'
			]
		);

		$controls->add_control(
			'submenu_last_item_switcher',
			[
				'label' => esc_html__( 'Last Item Options', 'stratum-menu' ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$controls->add_responsive_control(
			'submenu_last_item_margin',
			[
				'label'      => esc_html__( 'Margin', 'stratum-menu' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item:last-child > .stratum-menu-item__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'submenu_last_item_switcher' => 'yes'
				],
			]
		);

		$controls->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'submenu_last_item_border',
				'selector'  => '{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item:last-child > .stratum-menu-item__wrapper',
				'condition' => [
					'submenu_last_item_switcher' => 'yes'
				],
			]
		);

		$controls->add_responsive_control(
			'submenu_last_item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .stratum-mega-menu-sub-menu > .stratum-menu-item:last-child > .stratum-menu-item__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'submenu_last_item_switcher' => 'yes'
				],
			]
		);

		$controls->end_controls_section();

		$controls->start_controls_section(
			'section_item_icon',
			[
				'label' => esc_html__( 'Icon Style', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'item_icon_spacing',
				[
					'label' => esc_html__( 'Spacing', 'stratum-menu' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}}.stratum-menu-icon-ha-right .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-icon' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: 0;',
						'{{WRAPPER}}.stratum-menu-icon-ha-right .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-icon' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: 0;',
					],
				]
			);

			$controls->add_control(
				'item_icon_horizontal_alignment',
				[
					'label' => esc_html__( 'Alignment', 'stratum-menu' ),
					'type' => Controls_Manager::CHOOSE,
					'prefix_class' => 'stratum-menu-icon-ha-',
					'default' => '',
					'toggle' => false,
					'options' => [
						'left'    => [
							'title' => esc_html__( 'Left', 'stratum-menu' ),
							'icon' => 'eicon-h-align-left',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'stratum-menu' ),
							'icon' => 'eicon-h-align-right',
						],
					],
				]
			);

			$controls->add_responsive_control(
				'item_icon_size',
				[
					'label' => esc_html__( 'Size', 'stratum-menu' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-icon' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-icon > svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-icon' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$controls->start_controls_tabs( 'item_icon_styles' );

				$controls->start_controls_tab(
					'item_icon_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_icon_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-icon' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu > .stratum-menu-item .stratum-menu-icon' => 'color: {{VALUE}}',
							],
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'item_icon_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_icon_hover_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-icon' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-icon' => 'color: {{VALUE}}',
							],
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

		$controls->end_controls_section();

		$controls->start_controls_section(
			'section_item_dropdown',
			[
				'label' => esc_html__( 'Arrow Style', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'item_dropdown_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu .stratum-menu-item .stratum-menu-dropdown' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'item_dropdown_spacing',
				[
					'label' => esc_html__( 'Spacing', 'stratum-menu' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}}.stratum-menu-dropdown-ha-left .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-dropdown' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: 0;',
						'{{WRAPPER}}.stratum-menu-dropdown-ha-left .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-dropdown' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: 0;',
						'{{WRAPPER}}.stratum-menu-dropdown-ha-right .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-dropdown' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: 0;',
						'{{WRAPPER}}.stratum-menu-dropdown-ha-right .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-dropdown' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: 0;',
					],
				]
			);

			$controls->add_control(
				'item_dropdown_horizontal_alignment',
				[
					'label' => esc_html__( 'Alignment', 'stratum-menu' ),
					'type' => Controls_Manager::CHOOSE,
					'prefix_class' => 'stratum-menu-dropdown-ha-',
					'default' => 'right',
					'toggle' => false,
					'options' => [
						'left'    => [
							'title' => esc_html__( 'Left', 'stratum-menu' ),
							'icon' => 'eicon-h-align-left',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'stratum-menu' ),
							'icon' => 'eicon-h-align-right',
						],
					],
				]
			);

			$controls->add_responsive_control(
				'item_dropdown_size',
				[
					'label' => esc_html__( 'Size', 'stratum-menu' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-dropdown' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-dropdown' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-dropdown svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-dropdown > svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'item_dropdown_border',
					'selector' => '{{WRAPPER}} .stratum-top-mega-menu .stratum-menu-item .stratum-menu-dropdown',
				]
			);

			$controls->add_responsive_control(
				'item_dropdown_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu .stratum-menu-item .stratum-menu-dropdown' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->start_controls_tabs( 'item_dropdown_styles' );

				$controls->start_controls_tab(
					'item_dropdown_tab',
					array(
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					)
				);

					$controls->add_control(
						'item_dropdown_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-dropdown' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-dropdown' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-dropdown svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-dropdown svg > g' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-dropdown svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-dropdown svg > g' => 'fill: {{VALUE}}',
							],
						]
					);

					$controls->add_control(
						'arrow_background_color',
						[
							'label' => esc_html__( 'Background Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu .stratum-menu-item .stratum-menu-dropdown' => 'background-color: {{VALUE}}',
							],
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'item_dropdown_tab_hover',
					array(
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					)
				);

					$controls->add_control(
						'item_dropdown_color_hover',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-dropdown' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item:hover > .stratum-menu-item__wrapper > .stratum-menu-dropdown' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-dropdown svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-dropdown svg > g' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper > .stratum-menu-dropdown svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item:hover > .stratum-menu-item__wrapper > .stratum-menu-dropdown svg > g' => 'fill: {{VALUE}}',
							],
						]
					);

					$controls->add_control(
						'arrow_background_color_hover',
						[
							'label' => esc_html__( 'Background Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-dropdown' => 'background-color: {{VALUE}}',
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper > .stratum-menu-dropdown' => 'background-color: {{VALUE}}',
							],
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

		$controls->end_controls_section();

        $controls->start_controls_section(
			'section_item_badge',
			[
				'label' => esc_html__( 'Badge Style (First Level)', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'item_badge_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'item_badge_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'item_badge_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'item_badge_border',
					'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
				]
			);

			$controls->add_responsive_control(
				'item_badge_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'label'    => esc_html__( 'Typography', 'stratum-menu' ),
					'name'     => 'item_badge_typography',
					'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
				]
			);

			$controls->start_controls_tabs( 'item_badge_styles' );

				$controls->start_controls_tab(
					'item_badge_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_badge_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'item_badge_bg_color',
							'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'item_badge_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_badge_hover_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-badge' => 'color: {{VALUE}}',
							],
						]
					);


					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'item_hover_badge_bg_color',
							'selector' => '{{WRAPPER}} .stratum-top-mega-menu > .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-badge',
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

		$controls->end_controls_section();

        $controls->start_controls_section(
			'section_item_badge_submenu',
			[
				'label' => esc_html__( 'Badge Style (Nested Levels)', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'item_badge_submenu_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'item_badge_submenu_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'item_badge_submenu_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'item_badge_submenu_border',
					'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
				]
			);

			$controls->add_responsive_control(
				'item_badge_submenu_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'label'    => esc_html__( 'Typography', 'stratum-menu' ),
					'name'     => 'item_badge_submenu_typography',
					'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
				]
			);

			$controls->start_controls_tabs( 'item_badge_submenu_styles' );

				$controls->start_controls_tab(
					'item_badge_submenu_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_badge_submenu_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'item_submenu_badge_bg_color',
							'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item > .stratum-menu-item__wrapper .stratum-menu-badge',
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'item_badge_submenu_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_badge_submenu_hover_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-badge' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'item_submenu_hover_badge_bg_color',
							'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-badge',
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

		$controls->end_controls_section();

		$controls->start_controls_section(
			'section_sub_menu',
			[
				'label' => esc_html__( 'Dropdown Style', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_control(
				'sub_menu_width',
				[
					'label'       => esc_html__( 'Width', 'stratum-menu' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units'  => [ '%', 'px' ],
					'range'       => [
						'px' => [
							'min' => 0,
							'max' => 800,
						],
					],
					'selectors'   => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'sub_menu_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'sub_menu_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						// fix issue when submenu margin affect hover behavior
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu:before' => 'top: -{{TOP}}{{UNIT}}; right: -{{RIGHT}}{{UNIT}}; bottom: -{{BOTTOM}}{{UNIT}}; left: -{{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'sub_menu_border',
					'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu',
				]
			);

			$controls->add_responsive_control(
				'sub_menu_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'sub_menu_bg_color',
					'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu',
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'sub_menu_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu',
				]
			);

		$controls->end_controls_section();

		$controls->start_controls_section(
			'section_sub_menu_children',
			[
				'label' => esc_html__( 'Dropdown Style (Nested Levels)', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'sub_menu_children_margin',
				[
					'label'       => esc_html__( 'Margin', 'stratum-menu' ),
					'type'        => Controls_Manager::DIMENSIONS,
					'size_units'  => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu-simple.stratum-mega-menu-sub-menu .stratum-sub-menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$controls->end_controls_section();

		$controls->start_controls_section(
			'section_mega_menu',
			[
				'label' => esc_html__( 'Dropdown Style (Mega Menu)', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_control(
				'mega_menu_full_width',
				[
					'label' => esc_html__( 'Full Width', 'stratum-menu' ),
					'type' => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'return_value' => 'yes'
				]
			);

			$controls->add_responsive_control(
				'mega_menu_width',
				[
					'label'       => esc_html__( 'Width', 'stratum-menu' ),
					'type'        => Controls_Manager::SLIDER,
					'range'       => [
						'px' => [
							'min' => 100,
							'max' => 2800,
						],
					],
					'selectors'   => [
						'{{WRAPPER}} .stratum-sub-menu.stratum-sub-mega-menu .stratum-sub-mega-menu__wrapper' => 'max-width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'mega_menu_full_width!' => 'yes'
					],
				]
			);

			$controls->add_responsive_control(
				'mega_menu_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'placeholder' => [
						'left' => 'auto',
						'right' => 'auto',
					],
					'default' => [
						'left' => 'auto',
						'right' => 'auto',
						'isLinked' => false,
					],
					'allowed_dimensions' => 'vertical',
					'selectors'  => [
						'{{WRAPPER}} .stratum-sub-menu.stratum-sub-mega-menu .stratum-sub-mega-menu__wrapper' => 'margin-top: {{TOP}}{{UNIT}};margin-bottom: {{BOTTOM}}{{UNIT}};',
					],
				]
			);

		$controls->end_controls_section();

		$controls->start_controls_section(
			'section_responsive',
			[
				'label' => esc_html__( 'Responsive Settings', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_control(
				'responsive_breakpoint_switcher',
				[
					'label'   	   => esc_html__( 'Show Hamburger Menu', 'stratum-menu' ),
					'type'    	   => Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default' 	   => 'yes',
				]
			);

			$controls->add_control(
				'responsive_breakpoint',
				[
					'label'   	 => esc_html__( 'Breakpoint', 'stratum-menu' ),
					'description'=> esc_html__( 'Maximum screen width to display Hamburger Menu', 'stratum-menu' ),
					'type' 	  	 => Controls_Manager::NUMBER,
					'default' 	 => '768',
					'selectors'  => [
						'{{WRAPPER}}.elementor-widget-stratum-menu-mega-menu' => '--breakpoint: {{VALUE}}px;',
					],
					'condition'  => [
						'responsive_breakpoint_switcher' => 'yes'
					],
				]
			);

			$controls->add_responsive_control(
				'responsive_icon_alignment',
				[
					'label'   => esc_html__( 'Alignment', 'stratum-menu' ),
					'type'    => Controls_Manager::CHOOSE,
					'default'   => '',
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-left' : 'fa fa-align-right',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'stratum-menu' ),
							'icon'  => 'fa fa-align-center',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-right' : 'fa fa-align-left',
						],
						'stretch' => [
							'title' => esc_html__( 'Stretch', 'stratum-menu' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__button' => 'align-self: {{VALUE}};',
					],
				]
			);

			$controls->add_control(
				'responsive_menu_open_bg',
				[
					'label'       => esc_html__( 'Overlay Color', 'stratum-menu' ),
					'type' 	      => Controls_Manager::COLOR,
					'selectors'   => [
						'{{WRAPPER}} .stratum-mega-menu.stratum-menu-is-collapsable.stratum-menu-is-mobile > .stratum-menu-container' => 'background: {{VALUE}}',
					],
				]
			);

			$controls->add_responsive_control(
				'responsive_icon_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'responsive_icon_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'responsive_icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'stratum-menu' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__button' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__button svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$controls->add_control(
				'responsive_icon_tab_heading',
				[
					'label' 	 => esc_html__( 'Icon', 'stratum-menu' ),
					'type' 		 => Controls_Manager::HEADING,
					'separator'  => 'before'
				]
			);

			$controls->start_controls_tabs( 'responsive_icon_styles' );

				$controls->start_controls_tab(
					'responsive_icon_tab',
					array(
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					)
				);

					$controls->add_control(
						'toggle_open_text',
						[
							'label' => __( 'Title', 'stratum-menu' ),
							'type' => Controls_Manager::TEXT,
							'default' => __( 'Menu', 'stratum-menu' )
						]
					);

					$controls->add_control(
						'responsive_icon_color',
						[
							'label' => esc_html__( 'Icon Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__button' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__icon > svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__icon > svg > g' => 'fill: {{VALUE}}',
							],
						]
					);

					$controls->add_control(
						'responsive_icon_bg_color',
						[
							'label' => esc_html__( 'Background Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-mega-menu-toggle .stratum-menu-toggle__button' => 'background-color: {{VALUE}}',
							],
						]
					);

					$controls->add_control(
						'responsive_icon',
						[
							'label' => esc_html__( 'Icon', 'stratum-menu' ),
							'type' => Controls_Manager::ICONS,
							'default' => [
								'value' => 'fas fa-bars',
								'library' => 'solid',
							],
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'responsive_icon_active_tab',
					array(
						'label' => esc_html__( 'Active', 'stratum-menu' ),
					)
				);

					$controls->add_control(
						'toggle_close_text',
						[
							'label' => __( 'Title', 'stratum-menu' ),
							'type' => Controls_Manager::TEXT,
							'default' => __( 'Close', 'stratum-menu' )
						]
					);

					$controls->add_control(
						'responsive_icon_active_color',
						[
							'label' => esc_html__( 'Icon Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-mega-menu-toggle.is-opened .stratum-menu-toggle__button' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-mega-menu-toggle.is-opened .stratum-menu-toggle__icon > svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-mega-menu-toggle.is-opened .stratum-menu-toggle__icon > svg > g' => 'fill: {{VALUE}}',
							],
						]
					);

					$controls->add_control(
						'responsive_icon_active_bg_color',
						[
							'label' => esc_html__( 'Background Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-mega-menu-toggle.is-opened .stratum-menu-toggle__button' => 'background-color: {{VALUE}}',
							],
						]
					);

					$controls->add_control(
						'responsive_icon_active',
						[
							'label' => esc_html__( 'Icon', 'stratum-menu' ),
							'type' => Controls_Manager::ICONS,
							'default' => [
								'value' => 'fas fa-times',
								'library' => 'solid',
							],
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

		$controls->end_controls_section();
    }

	//PHP template (refresh elements)
    protected function render() {
		$settings = $this->get_settings();

		if ( ! isset( $settings[ 'menu' ] ) ) {
			return;
		}

		if ( $settings[ 'menu' ] ) {
    		$this->render_widget( 'php' );
		}
	}

	protected function content_template() {}
	public function render_plain_content( $instance = [] ) {}
}

Plugin::instance()->widgets_manager->register( new Mega_Menu() );
