<?php

namespace Noptin\WooCommerce\Triggers;

/**
 * Subscription status change.
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Subscription status change.
 *
 * @since 1.0.0
 */
class Subscription_Status_Change extends Subscription_Trigger {

	/**
	 * @var string The hook.
	 */
	protected $hook;

	/**
	 * @var string The name.
	 */
	protected $name;

	/**
	 * @var string The description.
	 */
	protected $description;

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 * @return string
	 */
	public function __construct( $hook, $name, $description ) {
		$this->hook        = $hook;
		$this->name        = $name;
		$this->description = $description;

		add_action( $this->hook, array( $this, 'trigger_for_subscription' ) );

		if ( 'woocommerce_checkout_subscription_created' === $this->hook ) {
			add_action( 'woocommerce_admin_created_subscription', array( $this, 'trigger_for_subscription' ) );
			add_action( 'wcs_api_subscription_created', array( $this, 'trigger_for_subscription' ) );
		}
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return $this->hook;
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return sprintf(
			// translators: %s: The subscription status.
			__( 'WooCommerce Subscription > %s', 'noptin-woocommerce' ),
			$this->name
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return $this->description;
	}

}
