<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$menu_id = get_the_ID();
$uniq_menu_id = 'stratum-menu-' . $menu_id;

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		<?php if ( ! current_theme_supports( 'title-tag' ) ) : ?>
		<title><?php echo wp_get_document_title(); ?></title>
		<?php endif; ?>
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		<div id="<?php echo $uniq_menu_id; ?>" class="stratum-menu stratum-menu--front-mode stratum-menu--single-preview">
			<div class="stratum-menu__inner">
				<div class="stratum-menu__container">
					<div class="stratum-menu__container-inner">
						<?php

							while ( have_posts() ) :
								the_post();
								the_content();
							endwhile;

						?>
					</div>
				</div>
			</div>
		</div>
	</body>
</html>