<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired before a user is deleted.
 *
 * @since 1.9.0
 */
class Delete_User extends New_User {

	/**
	 * Constructor.
	 *
	 * @since 1.9.0
	 * @return string
	 */
	public function __construct() {
		add_action( 'delete_user', array( $this, 'maybe_trigger' ), 1000 );
		add_action( 'remove_user_from_blog', array( $this, 'maybe_trigger' ), 1000 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'delete_user';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Delete User', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'Before a user is deleted', 'noptin-addons-pack' );
	}

}
