<?php

namespace Noptin\Addons_Pack\Users\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a WordPress user's role is added.
 *
 * @since 1.9.0
 */
class Add_User_Role extends Abstract_Trigger {

	/**
	 * Constructor.
	 *
	 * @since 1.9.0
	 * @return string
	 */
	public function __construct() {
		add_action( $this->get_id(), array( $this, 'maybe_trigger' ), 10, 2 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'add_user_role';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Add Role', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'When a role is added to a user', 'noptin-addons-pack' );
	}

	/**
     * Returns an array of known smart tags.
     *
     * @since 1.9.0
     * @return array
     */
    public function get_known_smart_tags() {

		$options = array();

		if ( function_exists( 'get_editable_roles' ) ) {
			$options = array_map( 'translate_user_role', wp_list_pluck( array_reverse( get_editable_roles() ), 'name' ) );
		}

		return array_replace(
			array(
				'role' => array(
					'description'       => __( 'The role', 'noptin-addons-pack' ),
					'example'           => 'role',
					'conditional_logic' => 'string',
					'default'           => 'subscriber',
					'options'           => $options,
				),
			),
			parent::get_known_smart_tags()
		);
	}

	/**
	 * Called when someone creates a new account.
	 *
	 * @param int $user_id  User ID.
	 * @param string $role  User role.
	 */
	public function maybe_trigger( $user_id, $role ) {
		$user = get_userdata( $user_id );

		if ( ! $user ) {
			return;
		}

		$this->trigger( $user, array( 'role' => $role ) );
	}

	/**
	 * Prepares email test data.
	 *
	 * @since 1.11.0
	 * @param Noptin_Automation_Rule $rule
	 * @return Noptin_Automation_Rules_Smart_Tags
	 * @throws Exception
	 */
	public function get_test_smart_tags( $rule ) {

		$user = wp_get_current_user();
		$args = $this->prepare_trigger_args( $user, array( 'role' => current( $user->roles ) ) );

		return $args['smart_tags'];
	}
}
