<?php

namespace Noptin\Addons_Pack\Users\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Handles all user related actions.
 *
 * @since 1.9.0
 */
abstract class Abstract_Action extends \Noptin_Abstract_Action {

	/**
	 * @var string
	 */
	public $category = 'WordPress Users';

	/**
	 * @inheritdoc
	 */
	public function get_image() {
		return array(
			'icon' => 'admin-users',
			'fill' => '#404040',
		);
	}

	/**
	 * Returns whether or not the action can run (dependancies are installed).
	 *
	 * @since 1.3.3
	 * @param mixed $subject The subject.
	 * @param Noptin_Automation_Rule $rule The automation rule used to trigger the action.
	 * @param array $args Extra arguments passed to the action.
	 * @return bool
	 */
	public function can_run( $subject, $rule, $args ) {

		// Fetch the user.
		$user = $this->get_user( $subject, $rule, $args );

		return ! empty( $user ) && ! is_wp_error( $user );
	}

	/**
	 * Fetches the current user.
	 *
	 * @since 1.10.0
	 * @param mixed $subject The subject.
	 * @param \Noptin_Automation_Rule $rule The automation rule used to trigger the action.
	 * @param array $args Extra arguments passed to the action.
	 * @return \WP_User|false
	 */
	public function get_user( $subject, $rule, $args ) {
		return get_user_by( 'email', $this->get_subject_email( $subject, $rule, $args ) );
	}
}
