<?php

namespace Noptin\Addons_Pack\Custom_Fields\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Adds a subscriber to a custom field.
 *
 * @since 2.0.0
 */
class Add_To_Field extends Abstract_Action {

	/**
	 * @var string
	 */
	public $is_multiple = true;

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'add_to_' . $this->merge_tag;
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Subscriber > Add to %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Adds the subscriber to %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_rule_table_description( $rule ) {
		$settings = $rule->action_settings;

		// Ensure we have a value.
		if ( empty( $settings[ $this->merge_tag ] ) ) {
			return sprintf(
				'<span class="noptin-rule-error">%s</span>',
				esc_html__( 'Error: No value specified', 'noptin-addons-pack' )
			);
		}

		$values   = noptin_parse_list( $settings[ $this->merge_tag ], true );
		$prepared = array();
		$options  = $this->get_options();

		foreach ( $values as $value ) {
			$prepared[] = isset( $options[ $value ] ) ? $options[ $value ] : $value;
		}

		return $this->rule_action_meta(
			array(
				$this->label => esc_html( implode( ', ', $prepared ) ),
			),
			$rule
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_settings() {
		return array(

			$this->merge_tag => array(
				'el'      => 'tags' === $this->merge_tag ? 'form_token' : 'multi_checkbox_alt',
				'label'   => $this->label,
				'options' => $this->get_options(),
				'default' => array(),
			),
		);
	}

	/**
	 * @inheritdoc
	 */
	public function run( $subject, $rule, $args ) {

		$subscriber = $this->get_subscriber( $subject, $rule, $args );

		if ( ! $subscriber->exists() ) {
			return;
		}

		// Fetch the custom field.
		$value    = noptin_parse_list( $rule->action_settings[ $this->merge_tag ], true );
		$existing = noptin_parse_list( $subscriber->get( $this->merge_tag, array() ), true );

		// Merge the values.
		$subscriber->set( $this->merge_tag, array_unique( array_merge( $existing, $value ) ) );
		$subscriber->save();
	}
}
