<?php
/**
 * Class: Counter
 * Name: Counter
 * Slug: stratum-counter
 */

namespace Stratum_Menu;

use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Menu extends Stratum_Menu_Widget_Base {
	protected $widget_name = 'menu';

    public function __construct($data = [], $args = null) {
        parent::__construct( $data, $args );
    }

	public function get_title() {
		return esc_html__( 'Plain Menu', 'stratum-menu' );
	}

	public function get_script_depends() {
        return [
			'font-awesome-4-shim'
		];
	}

	public function get_style_depends() {
        return [
			'font-awesome-5-all',
			'font-awesome-4-shim'
        ];
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_keywords() {
		return [ 'menu', 'nav', 'button' ];
	}

	public function get_categories() {
		return [ 'stratum-widgets' ];
    }

    protected function register_controls() {
        $controls = $this;

		/*-----------------------------------------------------------------------------------*/
        /*	Content Tab
        /*-----------------------------------------------------------------------------------*/

        $controls->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Menu', 'stratum-menu' )
			]
        );

			$controls->add_control(
				'menu',
				[
					'label'   => esc_html__( 'Select Menu', 'stratum-menu' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => stratum_menu_get_menu_list(),
					'description' => sprintf( __( 'Manage <a href="%s" target="_blank">Menus</a>.', 'stratum-menu' ), admin_url( 'nav-menus.php' ) ),
				]
			);

		$controls->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*	Style Tab
		/*-----------------------------------------------------------------------------------*/

/* Menu */
		$controls->start_controls_section(
			'section_menu',
			[
				'label' => esc_html__( 'Menu', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'menu_container_alignment',
				[
					'label'   => esc_html__( 'Alignment', 'stratum-menu' ),
					'type'    => Controls_Manager::CHOOSE,
					'default'   => '',
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-left' : 'fa fa-align-right',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'stratum-menu' ),
							'icon'  => 'fa fa-align-center',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-right' : 'fa fa-align-left',
						],
						'stretch' => [
							'title' => esc_html__( 'Stretch', 'stratum-menu' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-top-menu' => 'align-items: {{VALUE}};',
					],
				]
			);

			$controls->add_responsive_control(
				'menu_container_width',
				[
					'label'       => esc_html__( 'Width', 'stratum-menu' ),
					'type'        => Controls_Manager::SLIDER,
					'size_units' => [ '%', 'px' ],
					'range'       => [
						'px' => [
							'min' => 0,
							'max' => 1500,
						],
					],
					'selectors'   => [
						'{{WRAPPER}} .stratum-menu-wrapper' => 'max-width: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$controls->end_controls_section();

		/* Menu Items */
		$controls->start_controls_section(
			'section_menu_items',
			[
				'label'      => esc_html__( 'Menu Items', 'stratum-menu' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			]
		);

			$controls->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'label'    => esc_html__( 'Typography', 'stratum-menu' ),
					'name'     => 'menu_items_typography',
					'selector' => '{{WRAPPER}} .top-level-link',
				]
			);

			$controls->add_control(
				'menu_menu_top_items_text_align',
				[
					'label'     => esc_html__( 'Alignment', 'stratum-menu' ),
					'type'      => Controls_Manager::CHOOSE,
					'default'   => '',
					'options'   => [
						'left' => [
							'title' => esc_html__( 'Left', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-left' : 'fa fa-align-right',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'stratum-menu' ),
							'icon'  => 'fa fa-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'stratum-menu' ),
							'icon'  => ! is_rtl() ? 'fa fa-align-right' : 'fa fa-align-left',
						],
						'stretch' => [
							'title' => esc_html__( 'Stretch', 'stratum-menu' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'prefix_class' => 'stratum-menu-items-ta-',
					'condition'   => [
						'menu_container_alignment' => 'stretch'
					],
				]
			);

			$controls->start_controls_tabs( 'menu_items_styles' );

				$controls->start_controls_tab(
					'menu_items_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'menu_items_text_color',
						[
							'label' => esc_html__( 'Text Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .top-level-link' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'menu_items_bg_color',
							'selector' => '{{WRAPPER}} .stratum-top-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'menu_items_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'menu_items_hover_text_color',
						[
							'label' => esc_html__( 'Text Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-menu-item:hover .top-level-link' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'menu_items_hover_bg_color',
							'selector' => '{{WRAPPER}} .stratum-menu-item:hover > .stratum-menu-item__wrapper',
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

			$controls->add_responsive_control(
				'menu_items_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'menu_items_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .stratum-top-menu > .stratum-menu-item:first-child > .stratum-menu-item__wrapper' => 'margin-top: 0;',
						'{{WRAPPER}} .stratum-top-menu > .stratum-menu-item:last-child > .stratum-menu-item__wrapper' => 'margin-bottom: 0;',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'menu_items_items_border',
					'selector' => '{{WRAPPER}} .stratum-top-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
				]
			);

			$controls->add_responsive_control(
				'menu_items_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-top-menu > .stratum-menu-item > .stratum-menu-item__wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'menu_items_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-top-menu > .stratum-menu-item > .stratum-menu-item__wrapper',
				]
			);

		$controls->end_controls_section();

/* Item Icon */
		$controls->start_controls_section(
			'section_item_icon',
			[
				'label' => esc_html__( 'Item Icon', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'item_icon_spacing',
				[
					'label' => esc_html__( 'Spacing', 'stratum-menu' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-menu-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}}.stratum-menu-icon-ha-right .stratum-menu-icon' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: 0;',
					],
				]
			);

			$controls->add_control(
				'item_icon_horizontal_alignment',
				[
					'label' => esc_html__( 'Alignment', 'stratum-menu' ),
					'type' => Controls_Manager::CHOOSE,
					'prefix_class' => 'stratum-menu-icon-ha-',
					'default' => '',
					'toggle' => false,
					'options' => [
						'left'    => [
							'title' => esc_html__( 'Left', 'stratum-menu' ),
							'icon' => 'eicon-h-align-left',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'stratum-menu' ),
							'icon' => 'eicon-h-align-right',
						],
					],
				]
			);

			$controls->add_responsive_control(
				'item_icon_size',
				[
					'label' => esc_html__( 'Size', 'stratum-menu' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .stratum-menu-icon' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .stratum-menu-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$controls->start_controls_tabs( 'item_icon_styles' );

				$controls->start_controls_tab(
					'item_icon_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_icon_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-menu-icon' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-menu-icon svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-menu-icon svg > g' => 'fill: {{VALUE}}',
							],
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'item_icon_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_icon_hover_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-icon' => 'color: {{VALUE}}',
								'{{WRAPPER}} .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-icon svg > path' => 'fill: {{VALUE}}',
								'{{WRAPPER}} .stratum-menu-item:hover > .stratum-menu-item__wrapper .stratum-menu-icon svg > g' => 'fill: {{VALUE}}',
							],
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

		$controls->end_controls_section();

/* Item Badge */
        $controls->start_controls_section(
			'section_item_badge',
			[
				'label' => esc_html__( 'Item Badge', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'label'    => esc_html__( 'Typography', 'stratum-menu' ),
					'name'     => 'item_badge_typography',
					'selector' => '{{WRAPPER}} .top-level-link ~ .stratum-menu-badge',
				]
			);

			$controls->start_controls_tabs( 'item_badge_styles' );

				$controls->start_controls_tab(
					'item_badge_tab',
					[
						'label' => esc_html__( 'Normal', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_badge_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .top-level-link ~ .stratum-menu-badge' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'item_badge_bg_color',
							'selector' => '{{WRAPPER}} .top-level-link ~ .stratum-menu-badge',
						]
					);

				$controls->end_controls_tab();

				$controls->start_controls_tab(
					'item_badge_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'stratum-menu' ),
					]
				);

					$controls->add_control(
						'item_badge_hover_color',
						[
							'label' => esc_html__( 'Color', 'stratum-menu' ),
							'type' => Controls_Manager::COLOR,
							'render_type' => 'ui',
							'selectors' => [
								'{{WRAPPER}} .stratum-menu-item:hover .top-level-link ~ .stratum-menu-badge' => 'color: {{VALUE}}',
							],
						]
					);

					$controls->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name'     => 'item_hover_badge_bg_color',
							'selector' => '{{WRAPPER}} .stratum-menu-item:hover .top-level-link ~ .stratum-menu-badge',
						]
					);

				$controls->end_controls_tab();

			$controls->end_controls_tabs();

			$controls->add_responsive_control(
				'item_badge_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .top-level-link ~ .stratum-menu-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_responsive_control(
				'item_badge_margin',
				[
					'label'      => esc_html__( 'Margin', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .top-level-link ~ .stratum-menu-badge' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'item_badge_box_shadow',
					'selector' => '{{WRAPPER}} .top-level-link ~ .stratum-menu-badge',
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'item_badge_border',
					'selector' => '{{WRAPPER}} .top-level-link ~ .stratum-menu-badge',
				]
			);

			$controls->add_responsive_control(
				'item_badge_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .top-level-link ~ .stratum-menu-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$controls->end_controls_section();

/* Advanced */
		$controls->start_controls_section(
			'section_container',
			[
				'label' => esc_html__( 'Advanced', 'stratum-menu' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);

			$controls->add_responsive_control(
				'menu_container_padding',
				[
					'label'      => esc_html__( 'Padding', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-menu-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name'     => 'menu_container_border',
					'selector' => '{{WRAPPER}} .stratum-menu-wrapper',
				]
			);

			$controls->add_responsive_control(
				'menu_container_border_radius',
				[
					'label'      => esc_html__( 'Border Radius', 'stratum-menu' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .stratum-menu-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow:hidden;',
					],
				]
			);

			$controls->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name'     => 'menu_container_bg_color',
					'selector' => '{{WRAPPER}} .stratum-menu-wrapper',
				]
			);

			$controls->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'menu_container_box_shadow',
					'selector' => '{{WRAPPER}} .stratum-menu-wrapper',
				]
			);

		$controls->end_controls_section();
    }

	//PHP template (refresh elements)
    protected function render() {
		$settings = $this->get_settings();

   	 	if ( ! isset( $settings[ 'menu' ] ) ) {
			return;
		}

		if ( $settings[ 'menu' ]  ) {
			$this->render_widget( 'php' );
		}
	}

	protected function content_template() {}
	public function render_plain_content( $instance = [] ) {}
}

Plugin::instance()->widgets_manager->register( new Menu() );
