<?php

namespace Noptin\Addons_Pack\Tasks;

/**
 * Displays a list of all tasks.
 */

defined( 'ABSPATH' ) || exit;

/**
 * Tasks table class.
 */
class Tasks_Table extends \Hizzle\Store\List_Table {

	/**
	 * Constructor function.
	 *
	 */
	public function __construct() {
		parent::__construct( \Hizzle\Store\Collection::instance( 'noptin_tasks' ) );
	}

	/**
	 * Logs column.
	 *
	 * @param Task $item item.
	 */
	public function column_logs( $item ) {
		$logs = $item->get_logs();

		if ( empty( $logs ) ) {
			return '&mdash;';
		}

		echo '<ol class="noptin-task-logs">';

		foreach ( $logs as $log ) {
			$date = gmdate( 'Y-m-d H:i:s', $log['date'] + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) );
			printf(
				'<li><strong>%s</strong><br /> %s</li>',
				esc_html( $date ),
				esc_html( $log['message'] )
			);
		}

		echo '</ol>';
	}

	/**
	 * Args column.
	 *
	 * @param Task $item item.
	 */
	public function column_hook( $item ) {
		return sprintf(
			'<div class="task-row-name-wrapper"><div class="row-title"><strong>%s</strong></div><div class="row-actions">%s</div></div>',
			esc_html( $item->get_hook() ),
			$this->get_task_row_actions( $item )
		);
	}

	/**
	 * Hook column.
	 *
	 * @param Task $item item.
	 */
	public function column_args( $item ) {
		$args = json_decode( $item->get_args(), true );

		if ( empty( $args ) ) {
			return '&mdash;';
		}

		echo '<ul>';
		foreach ( $args as $key => $value ) {
			printf(
				'<li><code>%s => %s</code></li>',
				esc_html( var_export( $key, true ) ),
				esc_html( var_export( $value, true ) )
			);
		}
		echo '</ul>';
	}

	/**
	 * Returns available row actions.
	 *
	 * @param Task $item item.
	 * @return string
	 */
	public function get_task_row_actions( $item ) {

		$actions = array(

			'id' => sprintf(
				// translators: Task ID.
				esc_html__( 'ID: %d', 'noptin-addons-pack' ),
				absint( $item->get_id() )
			),

		);

		return $this->row_actions( $actions );
	}

	/**
	 * Table columns.
	 *
	 * @return array
	 */
	public function get_columns() {
		return array(
			'cb'             => '<input type="checkbox" />',
			'hook'           => __( 'Hook', 'noptin-addons-pack' ),
			'status'         => __( 'Status', 'noptin-addons-pack' ),
			'args'           => __( 'Args', 'noptin-addons-pack' ),
			'date_created'   => __( 'Created', 'noptin-addons-pack' ),
			'date_scheduled' => __( 'Scheduled For', 'noptin-addons-pack' ),
			'logs'           => __( 'Log', 'noptin-addons-pack' ),
		);
	}

	/**
	 * Table sortable columns.
	 *
	 * @return array
	 */
	public function get_sortable_columns() {
		return array(
			'hook'           => array( 'hook', true ),
			'status'         => array( 'status', true ),
			'date_created'   => array( 'date_created', true ),
			'date_scheduled' => array( 'date_scheduled', true ),
		);
	}

}
