<?php

namespace Noptin\Addons_Pack\Users\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Removes a user role.
 *
 * @since 1.10.0
 */
class Remove_User_Role extends Add_User_Role {

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'remove_user_role';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'User > Remove Role', 'noptin-addons-pack' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return __( 'Removes a role from the user', 'noptin-addons-pack' );
	}

	/**
	 * @param \WP_User $user
	 * @param string $role
	 */
	protected function process( $user, $role ) {
		$user->remove_role( $role );
	}
}
