<?php
/**
 * Database schema.
 *
 * Returns an array of the database schema.
 *
 */

defined( 'ABSPATH' ) || exit;

return array(

	// Tasks.
	'tasks' => array(
		'object'        => '\Noptin\Addons_Pack\Tasks\Task',
		'singular_name' => 'task',
		'props'         => array(

			'id'             => array(
				'type'        => 'BIGINT',
				'length'      => 20,
				'nullable'    => false,
				'description' => __( 'Unique identifier for this resource.', 'noptin-addons-pack' ),
				'readonly'    => true,
				'extra'       => 'AUTO_INCREMENT',
			),

			'hook'           => array(
				'type'        => 'VARCHAR',
				'length'      => 191,
				'nullable'    => false,
				'description' => __( 'The hook ID.', 'noptin-addons-pack' ),
			),

			'status'         => array(
				'type'        => 'VARCHAR',
				'length'      => 20,
				'nullable'    => false,
				'description' => __( 'The task status.', 'noptin-addons-pack' ),
			),

			'args'           => array(
				'type'        => 'TEXT',
				'description' => __( 'The args to pass to the hook.', 'noptin-addons-pack' ),
			),

			'args_hash'      => array(
				'type'        => 'VARCHAR',
				'length'      => 32,
				'nullable'    => false,
				'description' => __( 'The args hash.', 'noptin-addons-pack' ),
			),

			'date_created'   => array(
				'type'        => 'DATETIME',
				'nullable'    => false,
				'description' => __( 'Creation date for this task.', 'noptin-addons-pack' ),
				'readonly'    => true,
			),

			'date_modified'  => array(
				'type'        => 'DATETIME',
				'nullable'    => false,
				'description' => __( 'Last modification date for this task.', 'noptin-addons-pack' ),
				'readonly'    => true,
			),

			'date_scheduled' => array(
				'type'        => 'DATETIME',
				'nullable'    => false,
				'description' => __( 'Scheduled date for this task.', 'noptin-addons-pack' ),
			),

			'metadata'       => array(
				'type'        => 'TEXT',
				'description' => __( 'A key value array of additional metadata about the task', 'noptin-addons-pack' ),
			),
		),
		'keys'          => array(
			'primary'        => array( 'id' ),
			'status'         => array( 'status' ),
			'date_scheduled' => array( 'date_scheduled' ),
			'hook'           => array( 'hook' ),
		),
	),

);
